require( "quest/mg_package/convout.lua" );
require( "quest/activity_mode/activity_common.lua" );
combine_speech_tables();

-- HANDY DEBUG FLAGS!
local debug_show_placed_location = false;

round_num = 
{
	4, -- round one
	ACTIVITY_LEVEL_MAX, -- activity mode -- quest/activity_mode/activity_timer.lua
};

function get_activity_bonus_time(level)
	return MINUTES(1) + SECONDS(20) + SECONDS(3)*level*level;
end

initial_setup = true;
show_activity_text = false;

local gridSquare = 
{
	width = 46,
	height = 46,
	image = "gridSquare",
	highlight = "gridSquareHighlight",
	occupied = "gridSquareOccupied"
};

local gridFormatInfo = 
{
	grid_width = 6,
	grid_height = 8,
	screen_x_offset = 92,
	screen_y_offset = 33,
};

local floorFormatInfo = 
{
	floor_width = 330,
	floor_height = 600,
	screen_x_offset = 470,
	screen_y_offset = 0
}

local grid = { };
local package_items = { };

local gridSpawned = false;
numPackageItems = 0;

local currentDepth = 0;

local currentSolution = nil;
local currentHint = 1;
local maxHints = 0;
local autoPlace = false;
local globalFlo = nil;
local box = nil;
local boxlid = nil;
local passed = false;
local item_move_speed = 8; -- speed at which items 'walk' to their hint location

-- for the purposes of this activity, maxCollisionHeight and maxCollisionWidth should both be odd and should both be the same (may work if not same)
local collisionInfo = 
{	
	maxCollisionHeight = 5, 
	maxCollisionWidth = 5,
};

moving_actor = nil;

-- package items
local items = 
{
	-- activity one
	{
		-- level_one = 
		{
			items = 
			{
				{ image = "supply_28",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = true, depth = 5, x = 600, y = 20,		xCollisionCheckOffset = 61, yCollisionCheckOffset = 112, 	collisionMask = { 0, 0, 1, 1, 0, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1 } },
				{ image = "supply_21",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 4,	x = 490, y = 100,	xCollisionCheckOffset = 20, yCollisionCheckOffset = 110, 	collisionMask = { 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_19",	img_rotation = 90, img_scale = {x = 1, y = 1}, hint = false, depth = 3,	x = 754, y = 315,	xCollisionCheckOffset = -66, yCollisionCheckOffset = 58, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 0 } },
				{ image = "supply_18",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 2,	x = 500, y = 300,	xCollisionCheckOffset = 65, yCollisionCheckOffset = 66, 	collisionMask = { 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0 } },
				{ image = "supply_11",	img_rotation = 0, img_scale = {x = -1, y = 1}, hint = true, depth = 6,	x = 767, y = 262,	xCollisionCheckOffset = -113, yCollisionCheckOffset = 65, 	collisionMask = { 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } }
			};
			solution = 
			{
				{ x = 189, y = 170 }, -- supply_28
				{ x = 96, y = 216 }, -- supply_21
				{ x = 373, y = 41 }, -- supply_19
				{ x = 101, y = 33 }, -- supply_18
				{ x = 322, y = 32 } -- supply_11
			};
		};

		-- level_two = 
		{
			items = 
			{
				{ image = "supply_27",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 2,	x = 484, y = 17,	xCollisionCheckOffset = 65, yCollisionCheckOffset = 65, 	collisionMask = { 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1 } },
				{ image = "supply_29",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 8,	x = 749, y = 274,	xCollisionCheckOffset = 16, yCollisionCheckOffset = 105, 	collisionMask = { 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0 } },
				{ image = "supply_29",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 8,	x = 736, y = 41,	xCollisionCheckOffset = 16, yCollisionCheckOffset = 105, 	collisionMask = { 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0 } },
				{ image = "supply_20",	img_rotation = 90, img_scale = {x = 1, y = 1}, hint = false, depth = 8,	x = 732, y = 201,	xCollisionCheckOffset = -62, yCollisionCheckOffset = 114, 	collisionMask = { 0, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_13",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = true, depth = 2,	x = 553, y = 356,	xCollisionCheckOffset = 65, yCollisionCheckOffset = 20, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 1, 0 } },
				{ image = "supply_02", img_rotation = 90, img_scale = {x = 1, y = 1}, hint = true, depth = 5, x = 523, y = 388,		xCollisionCheckOffset = -20, yCollisionCheckOffset = 19, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_16",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = true, depth = 7,	x = 484, y = 215,	xCollisionCheckOffset = 65, yCollisionCheckOffset = 61, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0 } },
			};
			solution = 
			{
				{ x = 189, y = 33 }, -- supply_27
				{ x = 96, y = 33 }, -- supply_29
				{ x = 138, y = 41 }, -- supply_29
				{ x = 366, y = 216 }, -- supply_20
				{ x = 96, y = 260 }, -- supply_13
				{ x = 366, y = 260 }, -- supply_02
				{ x = 138, y = 218 } -- supply_16
							

			};
		};
		-- level_three = 
		{
			items = 
			{
				{ image = "supply_02", img_rotation = 0, img_scale = {x = 1, y = 1}, hint = true, depth = 5, x = 500, y = 121,		xCollisionCheckOffset = 65, yCollisionCheckOffset = 19, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_23", img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 4,	x = 644, y = 381,	xCollisionCheckOffset = 63, yCollisionCheckOffset = 108, 	collisionMask = { 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_19", img_rotation = 0, img_scale = {x = 1, y = 1}, hint = true, depth = 3,	x = 624, y = 231,	xCollisionCheckOffset = 56, yCollisionCheckOffset = 66, 	collisionMask = { 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_15", img_rotation = -90, img_scale = {x = 1, y = 1}, hint = false, depth = 2,	x = 490, y = 320,	xCollisionCheckOffset = 110, yCollisionCheckOffset = -108, 	collisionMask = { 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0 } },
				{ image = "supply_01", img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 6,	x = 540, y = 460,	xCollisionCheckOffset = 20, yCollisionCheckOffset = 20, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_22", img_rotation = 0, img_scale = {x = 1, y = 1}, hint = true, depth = 7,	x = 500, y = 260,	xCollisionCheckOffset = 109, yCollisionCheckOffset = 58, 	collisionMask = { 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 1, 0, 0 } },
				{ image = "supply_26",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 8,	x = 640, y = 50,	xCollisionCheckOffset = 63, yCollisionCheckOffset = 109, 	collisionMask = { 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0 } }
			};
			solution = 
			{
				{ x = 96, y = 36 }, -- supply_02
				{ x = 101, y = 260 }, -- supply_23
				{ x = 198, y = 32 }, -- supply_19
				{ x = 237, y = 305 }, -- supply_15
				{ x = 327, y = 308 }, -- supply_01
				{ x = 239, y = 216 }, --supply_22
				{ x = 101, y = 81 } -- supply_26
			};
		};
		-- level_four= 
		{
			items = 
			{
				{ image = "supply_28", img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 5, x = 500, y = 31,		xCollisionCheckOffset = 61, yCollisionCheckOffset = 112, 	collisionMask = { 0, 0, 1, 1, 0, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1 } },
				{ image = "supply_21", img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 4,	x = 689, y = 331,	xCollisionCheckOffset = 20, yCollisionCheckOffset = 110,  	collisionMask = { 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_09", img_rotation = 0, img_scale = {x = -1, y = 1}, hint = true, depth = 3,	x = 650, y = 275,	xCollisionCheckOffset = -67, yCollisionCheckOffset = 65, 	collisionMask = { 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_01", img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 2,	x = 500, y = 360,	xCollisionCheckOffset = 20, yCollisionCheckOffset = 20, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_03", img_rotation = 0, img_scale = {x = 1, y = 1}, hint = true, depth = 6,	x = 700, y = 210,	xCollisionCheckOffset = 67, yCollisionCheckOffset = 67, 	collisionMask = { 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_17", img_rotation = 0, img_scale = {x = 1, y = 1}, hint = true, depth = 7,	x = 500, y = 375,	xCollisionCheckOffset = 66, yCollisionCheckOffset = 63, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1, 1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_12",	img_rotation = -90, img_scale = {x = 1, y = 1}, hint = false, depth = 8, x = 700, y = 150,	xCollisionCheckOffset = 16, yCollisionCheckOffset = -65, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0 } }
			};
			solution = 
			{
				{ x = 189, y = 32 }, -- supply_28
				{ x = 96, y = 124 }, -- supply_21
				{ x = 230, y = 38 }, -- supply_09
				{ x = 327, y = 32 }, -- supply_01
				{ x = 97, y = 307 }, -- supply_03
				{ x = 146, y = 261 }, --supply_17
				{ x = 288, y = 396 } -- supply_12
			};
		};

	},
	
	-- activity mode
	{
		-- level_one = 
		{
			items = 
			{
				{ image = "supply_21", img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 4,	x = 493, y = 31,	xCollisionCheckOffset = 20, yCollisionCheckOffset = 110,  	collisionMask = { 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_23", img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 4,	x = 604, y = 58,	xCollisionCheckOffset = 63, yCollisionCheckOffset = 108, 	collisionMask = { 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_25", img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 3,	x = 652, y = 196,	xCollisionCheckOffset = 65, yCollisionCheckOffset = 110, 	collisionMask = { 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_28", img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 5, x = 480, y = 264,		xCollisionCheckOffset = 61, yCollisionCheckOffset = 112, 	collisionMask = { 0, 0, 1, 1, 0, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1 } },
				{ image = "supply_01", img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 6,	x = 493, y = 220,	xCollisionCheckOffset = 20, yCollisionCheckOffset = 20, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
			};
			solution = 
			{

			};
		};
		-- level_two = 
		{
			items = 
			{
				{ image = "supply_21", img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 4,	x = 617, y = 129,	xCollisionCheckOffset = 20, yCollisionCheckOffset = 110,  	collisionMask = { 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_23", img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 4,	x = 489, y = 20,	xCollisionCheckOffset = 63, yCollisionCheckOffset = 108, 	collisionMask = { 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_25", img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 3,	x = 626, y = 309,	xCollisionCheckOffset = 65, yCollisionCheckOffset = 110, 	collisionMask = { 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_25", img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 3,	x = 476, y = 284,	xCollisionCheckOffset = 65, yCollisionCheckOffset = 110, 	collisionMask = { 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_02", img_rotation = 0, img_scale = {x = 1, y = 1}, hint = true, depth = 5, x = 504, y =212,		xCollisionCheckOffset = 65, yCollisionCheckOffset = 19, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_29",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = true, depth = 8,	x = 720, y = 35,	xCollisionCheckOffset = 16, yCollisionCheckOffset = 105, 	collisionMask = { 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0 } },
				
			};
			solution = 
			{

			};
		};
		-- level_three = 
		{
			items = 
			{
				{ image = "supply_01", img_rotation = 0, img_scale = {x = 1, y = 1}, hint = true, depth = 2,	x = 552, y = 62,	xCollisionCheckOffset = 20, yCollisionCheckOffset = 20, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_25", img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 3,	x = 641, y = 56,	xCollisionCheckOffset = 65, yCollisionCheckOffset = 110, 	collisionMask = { 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_25", img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 3,	x = 478, y = 312,	xCollisionCheckOffset = 65, yCollisionCheckOffset = 110, 	collisionMask = { 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_11", img_rotation = 0, img_scale = {x = 1, y = 1}, hint = true, depth = 6,	x = 527, y = 272,	xCollisionCheckOffset = 113, yCollisionCheckOffset = 65, 	collisionMask = { 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_08",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 5,  x = 505, y = 169,	xCollisionCheckOffset = 67, yCollisionCheckOffset = 67, 	collisionMask = { 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_18",	img_rotation = 0, img_scale = {x = -1, y = 1}, hint = false, depth = 2,	x = 770, y = 275,	xCollisionCheckOffset = -65, yCollisionCheckOffset = 66, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0 } },
				{ image = "supply_13",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 2,	x = 493, y = 19,	xCollisionCheckOffset = 65, yCollisionCheckOffset = 20, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 1, 0 } },
							
			};
			solution = 
			{

			};
		};
		-- level_four = 
		{
			items = 
			{
				{ image = "supply_09",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = true, depth = 6,	x = 505, y = 18,	xCollisionCheckOffset = 64, yCollisionCheckOffset = 65, 	collisionMask = { 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } }, 
				{ image = "supply_10",	img_rotation = 90, img_scale = {x = 1, y = 1}, hint = false, depth = 4,	x = 750, y = 203,	xCollisionCheckOffset = -22, yCollisionCheckOffset = 65, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_26",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 8,	x = 508, y = 115,	xCollisionCheckOffset = 63, yCollisionCheckOffset = 109, 	collisionMask = { 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_26",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 8,	x = 656, y = 11,	xCollisionCheckOffset = 63, yCollisionCheckOffset = 109, 	collisionMask = { 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_29",	img_rotation = 90, img_scale = {x = 1, y = 1}, hint = true, depth = 8,	x = 689, y = 294,	xCollisionCheckOffset = -110, yCollisionCheckOffset = 16, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_08",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 5, x = 532, y = 353,	xCollisionCheckOffset = 67, yCollisionCheckOffset = 67, 	collisionMask = { 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_15",  img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 2,	x = 551, y = 359,	xCollisionCheckOffset = 108, yCollisionCheckOffset = 112, 	collisionMask = { 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				
			};
			solution = 
			{

			};
		};
		
		-- level_five = 
		{
			items = 
			{
				{ image = "supply_01", img_rotation = 0, img_scale = {x = 1, y = 1}, hint = true, depth = 2,	x = 556, y = 60,	xCollisionCheckOffset = 20, yCollisionCheckOffset = 20, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_01", img_rotation = 0, img_scale = {x = 1, y = 1}, hint = true, depth = 2,	x = 657, y = 180,	xCollisionCheckOffset = 20, yCollisionCheckOffset = 20, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_08",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 5,  x = 489, y = 179,	xCollisionCheckOffset = 67, yCollisionCheckOffset = 67, 	collisionMask = { 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_08",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 5,  x = 637, y = 30,	xCollisionCheckOffset = 67, yCollisionCheckOffset = 67, 	collisionMask = { 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_13",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 2,	x = 487, y = 372,	xCollisionCheckOffset = 65, yCollisionCheckOffset = 20, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 1, 0 } },
				{ image = "supply_13",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 2,	x = 489, y = 37,	xCollisionCheckOffset = 65, yCollisionCheckOffset = 20, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 1, 0 } },
				{ image = "supply_29",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = true, depth = 8,	x = 722, y = 275,	xCollisionCheckOffset = 16, yCollisionCheckOffset = 105, 	collisionMask = { 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0 } },
				{ image = "supply_29",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = true, depth = 8,	x = 748, y = 43,	xCollisionCheckOffset = 16, yCollisionCheckOffset = 105, 	collisionMask = { 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0 } },
				{ image = "supply_28",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = true, depth = 5, x = 530, y = 234,		xCollisionCheckOffset = 61, yCollisionCheckOffset = 112, 	collisionMask = { 0, 0, 1, 1, 0, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1 } },
			};
			solution = 
			{

			};
		};
		-- level_six = 
		{
			items = 
			{
				{ image = "supply_05",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 4,	x = 672, y = 249,	xCollisionCheckOffset = 14, yCollisionCheckOffset = 20, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_10",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 4,	x = 551, y = 35,	xCollisionCheckOffset = 20, yCollisionCheckOffset = 20, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_10",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 4,	x = 494, y = 298,	xCollisionCheckOffset = 20, yCollisionCheckOffset = 20, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_12",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 8, x = 489, y = 370,	xCollisionCheckOffset = 65, yCollisionCheckOffset = 65, 	collisionMask = { 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_21", img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 4,	x = 691, y = 55,	xCollisionCheckOffset = 20, yCollisionCheckOffset = 110,  	collisionMask = { 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_23", img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 4,	x = 646, y = 350,	xCollisionCheckOffset = 63, yCollisionCheckOffset = 108, 	collisionMask = { 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_27",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = true, depth = 2,	x = 489, y = 99,	xCollisionCheckOffset = 65, yCollisionCheckOffset = 65, 	collisionMask = { 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1 } },
				
			};
			solution = 
			{

			};
		};

		-- level_seven = 
		{
			items = 
			{
				{ image = "supply_10",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 4,	x = 650, y = 127,	xCollisionCheckOffset = 20, yCollisionCheckOffset = 20, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_10",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 4,	x = 502, y = 29,	xCollisionCheckOffset = 20, yCollisionCheckOffset = 20, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_10",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 4,	x = 476, y = 222,	xCollisionCheckOffset = 20, yCollisionCheckOffset = 20, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_10",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 4,	x = 660, y = 194,	xCollisionCheckOffset = 20, yCollisionCheckOffset = 20, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_10",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 4,	x = 484, y = 421,	xCollisionCheckOffset = 20, yCollisionCheckOffset = 20, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_12",	img_rotation = 0, img_scale = {x = 1, y = -1}, hint = false, depth = 8, x = 640, y = 111,	xCollisionCheckOffset = 65, yCollisionCheckOffset = -65, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_01", img_rotation = 0, img_scale = {x = 1, y = 1}, hint = true, depth = 2,	x = 617, y = 232,	xCollisionCheckOffset = 20, yCollisionCheckOffset = 20, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_04", img_rotation = 0, img_scale = {x = 1, y = 1}, hint = true, depth = 6,	x = 658, y = 378,	xCollisionCheckOffset = 67, yCollisionCheckOffset = 67, 	collisionMask = { 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_23", img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 4,	x = 493, y = 87,	xCollisionCheckOffset = 63, yCollisionCheckOffset = 108, 	collisionMask = { 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_24",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = true, depth = 7,	x = 472, y = 281,	xCollisionCheckOffset = 108, yCollisionCheckOffset = 61, 	collisionMask = { 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_14",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 4,	x = 655, y = 238,	xCollisionCheckOffset = 20, yCollisionCheckOffset = 67, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0 } },
				
			};
			solution = 
			{


			};
		};
		
		-- level_eight = 
		{
			items = 
			{
				{ image = "supply_04",	img_rotation = 90, img_scale = {x = 1, y = 1}, hint = false, depth = 3,	x = 739, y = 19,	xCollisionCheckOffset = -20, yCollisionCheckOffset = 67, 	collisionMask = { 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_04",	img_rotation = 90, img_scale = {x = 1, y = 1}, hint = false, depth = 3,	x = 586, y = 122,	xCollisionCheckOffset = -20, yCollisionCheckOffset = 67, 	collisionMask = { 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_03", img_rotation = 0, img_scale = {x = -1, y = -1}, hint = true, depth = 6,	x = 617, y = 108,	xCollisionCheckOffset = -22, yCollisionCheckOffset = -20, 	collisionMask = { 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_03", img_rotation = 0, img_scale = {x = -1, y = -1}, hint = true, depth = 6,	x = 792, y = 175,	xCollisionCheckOffset = -22, yCollisionCheckOffset = -20, 	collisionMask = { 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_21", img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 4,	x = 599, y = 130,	xCollisionCheckOffset = 20, yCollisionCheckOffset = 110,  	collisionMask = { 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_21", img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 4,	x = 701, y = 185,	xCollisionCheckOffset = 20, yCollisionCheckOffset = 110,  	collisionMask = { 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_08",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 5,  x = 487, y = 222,	xCollisionCheckOffset = 67, yCollisionCheckOffset = 67, 	collisionMask = { 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_17", img_rotation = 0, img_scale = {x = 1, y = 1}, hint = true, depth = 7,	x = 603, y = 366,	xCollisionCheckOffset = 66, yCollisionCheckOffset = 63, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1, 1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_19", img_rotation = 0, img_scale = {x = 1, y = 1}, hint = true, depth = 3,	x = 465, y = 316,	xCollisionCheckOffset = 56, yCollisionCheckOffset = 66, 	collisionMask = { 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0 } },
				

			};
			solution = 
			{

			};
		};

		-- level_nine = 
		{
			items = 
			{
				{ image = "supply_08",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 5, x = 500, y = 131,		xCollisionCheckOffset = 67, yCollisionCheckOffset = 67, 	collisionMask = { 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_10",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 4,	x = 494, y = 231,	xCollisionCheckOffset = 20, yCollisionCheckOffset = 20, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_04",	img_rotation = 90, img_scale = {x = 1, y = 1}, hint = false, depth = 3,	x = 590, y = 21,	xCollisionCheckOffset = -20, yCollisionCheckOffset = 67, 	collisionMask = { 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_27",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = true, depth = 2,	x = 590, y = 300,	xCollisionCheckOffset = 65, yCollisionCheckOffset = 65, 	collisionMask = { 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1 } },
				{ image = "supply_09",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = true, depth = 6,	x = 615, y = 170,	xCollisionCheckOffset = 64, yCollisionCheckOffset = 65, 	collisionMask = { 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } }, 
				{ image = "supply_16",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = true, depth = 7,	x = 588, y = 23,	xCollisionCheckOffset = 65, yCollisionCheckOffset = 61, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_29",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = true, depth = 8,	x = 490, y = 292,	xCollisionCheckOffset = 16, yCollisionCheckOffset = 105, 	collisionMask = { 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0 } },
				{ image = "supply_01", img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 2,	x = 530, y = 360,	xCollisionCheckOffset = 20, yCollisionCheckOffset = 20, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },			
				{ image = "supply_07",	img_rotation = 0, img_scale = {x = -1, y = -1}, hint = false, depth = 9, x = 766, y = 150,	xCollisionCheckOffset = -68, yCollisionCheckOffset = -69, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0 } }

			};
			solution = 
			{
				{ x = 281, y = 307 }, -- supply_08
				{ x = 189, y = 32 }, -- supply_10
				{ x = 97, y = 32 }, -- supply_04
				{ x = 97, y = 217 }, -- supply_27
				{ x = 189, y = 78 }, -- supply_09
				{ x = 98, y = 78 }, -- supply_16
				{ x = 327, y = 78 }, -- supply_29
				{ x = 327, y = 32 }, -- supply_01
				{ x = 235, y = 171 } -- supply_07

			};
		};


		-- level_ten = 
		{
			items = 
			{
				{ image = "supply_08",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 5,  x = 544, y = 252,	xCollisionCheckOffset = 67, yCollisionCheckOffset = 67, 	collisionMask = { 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_08",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 5,  x = 468, y = 167,	xCollisionCheckOffset = 67, yCollisionCheckOffset = 67, 	collisionMask = { 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_08",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 5,  x = 680, y = 305,	xCollisionCheckOffset = 67, yCollisionCheckOffset = 67, 	collisionMask = { 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_13",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 2,	x = 474, y = 363,	xCollisionCheckOffset = 65, yCollisionCheckOffset = 20, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 1, 0 } },
				{ image = "supply_15", img_rotation = -90, img_scale = {x = 1, y = 1}, hint = false, depth = 2,	x = 465, y = 231,	xCollisionCheckOffset = 110, yCollisionCheckOffset = -108, 	collisionMask = { 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0 } },
				{ image = "supply_15", img_rotation = -90, img_scale = {x = 1, y = 1}, hint = false, depth = 2,	x = 655, y = 316,	xCollisionCheckOffset = 110, yCollisionCheckOffset = -108, 	collisionMask = { 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0 } },
				{ image = "supply_16",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = true, depth = 7,	x = 613, y = 27,	xCollisionCheckOffset = 65, yCollisionCheckOffset = 61, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_18",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 2,	x = 630, y = 322,	xCollisionCheckOffset = 65, yCollisionCheckOffset = 66, 	collisionMask = { 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0 } },
				{ image = "supply_01", img_rotation = 0, img_scale = {x = 1, y = 1}, hint = true, depth = 2,	x = 476, y = 291,	xCollisionCheckOffset = 20, yCollisionCheckOffset = 20, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_01", img_rotation = 0, img_scale = {x = 1, y = 1}, hint = true, depth = 2,	x = 540, y = 381,	xCollisionCheckOffset = 20, yCollisionCheckOffset = 20, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
					
			};
			solution = 
			{

			};
		};


		-- level_eleven = 
		{
			items = 
			{
				{ image = "supply_03", img_rotation = 0, img_scale = {x = 1, y = 1}, hint = true, depth = 6,	x = 496, y = 213,	xCollisionCheckOffset = 67, yCollisionCheckOffset = 67, 	collisionMask = { 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_11", img_rotation = 0, img_scale = {x = 1, y = 1}, hint = true, depth = 6,	x = 602, y = 210,	xCollisionCheckOffset = 113, yCollisionCheckOffset = 65, 	collisionMask = { 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_19", img_rotation = 0, img_scale = {x = 1, y = 1}, hint = true, depth = 3,	x = 614, y = 330,	xCollisionCheckOffset = 56, yCollisionCheckOffset = 66, 	collisionMask = { 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_20",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = true, depth = 8,	x = 591, y = 24,	xCollisionCheckOffset = 68, yCollisionCheckOffset = 107, 	collisionMask = { 0, 1, 0, 0, 1, 0, 1, 1, 1, 1, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_01", img_rotation = 0, img_scale = {x = 1, y = 1}, hint = true, depth = 2,	x = 660, y = 141,	xCollisionCheckOffset = 20, yCollisionCheckOffset = 20, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_02", img_rotation = 0, img_scale = {x = 1, y = 1}, hint = true, depth = 5, x = 594, y = 277,		xCollisionCheckOffset = 65, yCollisionCheckOffset = 19, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_02", img_rotation = 90, img_scale = {x = 1, y = 1}, hint = true, depth = 5, x = 635, y = 377,		xCollisionCheckOffset = -16, yCollisionCheckOffset = 19, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_22", img_rotation = 0, img_scale = {x = 1, y = 1}, hint = true, depth = 7,	x = 488, y = 331,	xCollisionCheckOffset = 109, yCollisionCheckOffset = 58, 	collisionMask = { 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 1, 0, 0 } },
				{ image = "supply_22", img_rotation = 0, img_scale = {x = 1, y = 1}, hint = true, depth = 7,	x = 483, y = 30,	xCollisionCheckOffset = 109, yCollisionCheckOffset = 58, 	collisionMask = { 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 1, 0, 0 } },
				
			};
			solution = 
			{

			};
		};

		-- level_twelve = 
		{
			items = 
			{				
				{ image = "supply_03", img_rotation = 0, img_scale = {x = 1, y = 1}, hint = true, depth = 6,	x = 627, y = 75,	xCollisionCheckOffset = 67, yCollisionCheckOffset = 67, 	collisionMask = { 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_04",	img_rotation = 90, img_scale = {x = 1, y = 1}, hint = false, depth = 3,	x = 596, y = 70,	xCollisionCheckOffset = -20, yCollisionCheckOffset = 67, 	collisionMask = { 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_29",	img_rotation = 90, img_scale = {x = 1, y = 1}, hint = true, depth = 8,	x = 771, y = 21,	xCollisionCheckOffset = -110, yCollisionCheckOffset = 16, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_29",	img_rotation = 90, img_scale = {x = 1, y = 1}, hint = true, depth = 8,	x = 691, y = 178,	xCollisionCheckOffset = -110, yCollisionCheckOffset = 16, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_11", img_rotation = 0, img_scale = {x = 1, y = 1}, hint = true, depth = 6,	x = 605, y = 269,	xCollisionCheckOffset = 113, yCollisionCheckOffset = 65, 	collisionMask = { 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_11", img_rotation = 0, img_scale = {x = 1, y = 1}, hint = true, depth = 6,	x = 506, y = 321,	xCollisionCheckOffset = 113, yCollisionCheckOffset = 65, 	collisionMask = { 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_11", img_rotation = 90, img_scale = {x = 1, y = 1}, hint = true, depth = 6,	x = 786, y = 75,	xCollisionCheckOffset = -16, yCollisionCheckOffset = 63, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0 } },
				{ image = "supply_16",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = true, depth = 7,	x = 480, y = 360,	xCollisionCheckOffset = 65, yCollisionCheckOffset = 61, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_02", img_rotation = 90, img_scale = {x = 1, y = 1}, hint = true, depth = 5, x = 564, y = 218,		xCollisionCheckOffset = -16, yCollisionCheckOffset = 19, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_14",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 4,	x = 652, y = 360,	xCollisionCheckOffset = 20, yCollisionCheckOffset = 67, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0 } },
				
			};
			solution = 
			{

			};
		};
		
		
		-- level_thirteen = 
		{
			items = 
			{
				{ image = "supply_07",	img_rotation = -90, img_scale = {x = 1, y = 1}, hint = false, depth = 9, x = 471, y = 121,	xCollisionCheckOffset = 68, yCollisionCheckOffset = -23, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_07",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 9, x = 510, y = 297,	xCollisionCheckOffset = 68, yCollisionCheckOffset = 67, 	collisionMask = { 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_08",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 5,  x = 487, y = 194,	xCollisionCheckOffset = 67, yCollisionCheckOffset = 67, 	collisionMask = { 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_09",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = true, depth = 6,	x = 619, y = 400,	xCollisionCheckOffset = 64, yCollisionCheckOffset = 65, 	collisionMask = { 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } }, 
				{ image = "supply_10",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 4,	x = 479, y = 132,	xCollisionCheckOffset = 20, yCollisionCheckOffset = 20, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_10",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 4,	x = 619, y = 166,	xCollisionCheckOffset = 20, yCollisionCheckOffset = 20, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_10",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 4,	x = 483, y = 446,	xCollisionCheckOffset = 20, yCollisionCheckOffset = 20, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_19", img_rotation = 0, img_scale = {x = 1, y = 1}, hint = true, depth = 3,	x = 609, y = 36,	xCollisionCheckOffset = 56, yCollisionCheckOffset = 66, 	collisionMask = { 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_26",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 8,	x = 643, y = 220,	xCollisionCheckOffset = 63, yCollisionCheckOffset = 109, 	collisionMask = { 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_02", img_rotation = 90, img_scale = {x = 1, y = 1}, hint = true, depth = 5, x = 601, y = 293,		xCollisionCheckOffset = -16, yCollisionCheckOffset = 19, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0 } },
			
			};
			solution = 
			{

			};
		};



		-- level_fourteen = 
		{
			items = 
			{
				{ image = "supply_12",	img_rotation = 0, img_scale = {x = 1, y = -1}, hint = false, depth = 8, x = 504, y = 100,	xCollisionCheckOffset = 65, yCollisionCheckOffset = -65, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_16",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = true, depth = 7,	x = 649, y = 109,	xCollisionCheckOffset = 65, yCollisionCheckOffset = 61, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_29",	img_rotation = 90, img_scale = {x = 1, y = 1}, hint = true, depth = 8,	x = 762, y = 330,	xCollisionCheckOffset = -110, yCollisionCheckOffset = 16, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_01", img_rotation = 0, img_scale = {x = 1, y = 1}, hint = true, depth = 2,	x = 584, y = 286,	xCollisionCheckOffset = 20, yCollisionCheckOffset = 20, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_05",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 4,	x = 654, y = 249,	xCollisionCheckOffset = 14, yCollisionCheckOffset = 20, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_06",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 4,	x = 660, y = 12,	xCollisionCheckOffset = 17, yCollisionCheckOffset = 23, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0 } },
				{ image = "supply_07",	img_rotation = -90, img_scale = {x = 1, y = 1}, hint = false, depth = 9, x = 478, y = 278,	xCollisionCheckOffset = 68, yCollisionCheckOffset = -23, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_07",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 9, x = 481, y = 300,	xCollisionCheckOffset = 68, yCollisionCheckOffset = 67, 	collisionMask = { 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_09",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = true, depth = 6,	x = 504, y = 100,	xCollisionCheckOffset = 64, yCollisionCheckOffset = 65, 	collisionMask = { 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } }, 
				{ image = "supply_23", img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 4,	x = 599, y = 377,	xCollisionCheckOffset = 63, yCollisionCheckOffset = 108, 	collisionMask = { 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				
			};
			solution = 
			{

			};
		};

		-- level_fifteen = 
		{
			items = 
			{
				{ image = "supply_03",	img_rotation = 90, img_scale = {x = 1, y = 1}, hint = false, depth = 3,	x = 778, y = 390,	xCollisionCheckOffset = -20, yCollisionCheckOffset = 67, 	collisionMask = { 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_09",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = true, depth = 6,	x = 663, y = 31,	xCollisionCheckOffset = 64, yCollisionCheckOffset = 65, 	collisionMask = { 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } }, 
				{ image = "supply_10",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 4,	x = 472, y = 189,	xCollisionCheckOffset = 20, yCollisionCheckOffset = 20, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_13",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 2,	x = 662, y = 90,	xCollisionCheckOffset = 65, yCollisionCheckOffset = 20, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 1, 0 } },
				{ image = "supply_14",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 4,	x = 525, y = 358,	xCollisionCheckOffset = 20, yCollisionCheckOffset = 67, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_01", img_rotation = 0, img_scale = {x = 1, y = 1}, hint = true, depth = 2,	x = 722, y = 284,	xCollisionCheckOffset = 20, yCollisionCheckOffset = 20, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_01", img_rotation = 0, img_scale = {x = 1, y = 1}, hint = true, depth = 2,	x = 609, y = 16,	xCollisionCheckOffset = 20, yCollisionCheckOffset = 20, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_02", img_rotation = 90, img_scale = {x = 1, y = 1}, hint = true, depth = 5, x = 655, y = 188,		xCollisionCheckOffset = -16, yCollisionCheckOffset = 19, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_20",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = true, depth = 8,	x = 530, y = 237,	xCollisionCheckOffset = 68, yCollisionCheckOffset = 108, 	collisionMask = { 0, 1, 0, 0, 1, 0, 1, 1, 1, 1, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_24",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = true, depth = 7,	x = 480, y = 55,	xCollisionCheckOffset = 108, yCollisionCheckOffset = 61, 	collisionMask = { 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_29",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = true, depth = 8,	x = 480, y = 248,	xCollisionCheckOffset = 16, yCollisionCheckOffset = 105, 	collisionMask = { 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0 } },
				

			};
			solution = 
			{

			};
		};
		-- level_sixteen = 
		{
			items = 
			{

				--{ image = "supply_15",  img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 2,	x = 489, y = 369,	xCollisionCheckOffset = 108, yCollisionCheckOffset = 112, 	collisionMask = { 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_03",	img_rotation = 90, img_scale = {x = 1, y = 1}, hint = false, depth = 3,	x = 640, y = 154,	xCollisionCheckOffset = -20, yCollisionCheckOffset = 67, 	collisionMask = { 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_07",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 9, x = 482, y = 318,	xCollisionCheckOffset = 68, yCollisionCheckOffset = 67, 	collisionMask = { 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_05",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 4,	x = 634, y = 9,		xCollisionCheckOffset = 14, yCollisionCheckOffset = 20, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_06",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 4,	x = 462, y = 213,	xCollisionCheckOffset = 17, yCollisionCheckOffset = 23, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0 } },
				{ image = "supply_10",	img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 4,	x = 593, y = 279,	xCollisionCheckOffset = 20, yCollisionCheckOffset = 20, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_12",	img_rotation = -90, img_scale = {x = 1, y = 1}, hint = false, depth = 8, x = 721, y = 410,	xCollisionCheckOffset = 16, yCollisionCheckOffset = -65, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_15",  img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 2,	x = 576, y = 333,	xCollisionCheckOffset = 108, yCollisionCheckOffset = 112, 	collisionMask = { 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_21", img_rotation = 0, img_scale = {x = 1, y = 1}, hint = false, depth = 4,	x = 650, y = 97,	xCollisionCheckOffset = 20, yCollisionCheckOffset = 110,  	collisionMask = { 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_17", img_rotation = 0, img_scale = {x = 1, y = 1}, hint = true, depth = 7,	x = 484, y = 13,	xCollisionCheckOffset = 66, yCollisionCheckOffset = 63, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1, 1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_01", img_rotation = 0, img_scale = {x = 1, y = 1}, hint = true, depth = 2,	x = 480, y = 125,	xCollisionCheckOffset = 20, yCollisionCheckOffset = 20, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				{ image = "supply_01", img_rotation = 0, img_scale = {x = 1, y = 1}, hint = true, depth = 2,	x = 535, y = 330,	xCollisionCheckOffset = 20, yCollisionCheckOffset = 20, 	collisionMask = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
				
			};
			solution = 
			{

			};
		};
		

	},
};

function get_package_item_spec(_name, _info)
	return
	{
		name = "~" .. _name;
		halo = _info.image;
		gfx = { image = _info.image };		
		
		command = function(actor)
			actor:SetDepthValue(_info.depth);
			actor:JumpToPoint { x = _info.x, y = _info.y };
			actor:SetPointAtCursor("cursor_open_hand");
			actor:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
			actor:SetWalkSpeed(item_move_speed);
			actor.moving = false;
			actor:SetRadians(deg_to_rad(_info.img_rotation));
			actor:SetScaleXY(_info.img_scale);
			actor:ModifySaySpec
			{
				color = { a = 1, r = 0, g = 0, b = 0 },
				y = 30,
				x = -15,
				w = 90,
				h = 25,
				bubble = false,
				outline_size = 0,
				font = "fonts/garamondpremierpro.mvec"; 
				anchor = ANCHOR.CENTER
			};
			actor:SayRaw("");
			actor.info = _info;
			actor.collisionUsed = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
			actor.placed = false;
			actor.snapToPos = { x = 0, y = 0 };
			
			actor.on_click = function(flo, package_item)
				if ( passed == true ) then
					return;
				end
				if actor.moving == false and moving_actor == nil then
					local clickedAt = scene:GetClickedAtScreen();
					local actorPos = actor:GetPosition();
					actor.moving = true;
					actor.movingx = actorPos.x - clickedAt.x;
					actor.movingy = actorPos.y - clickedAt.y ;
					actor:SetDepthValue(currentDepth);
					currentDepth = currentDepth + 1;
					sfx:PlaySFX( "audio/sfx/pickup_supply.ogg", false );
					actor:LoadZone("over_actor");
					actor:SetPointAtCursor("cursor_closed_hand");
					actor:StartProc(move_item);
				else
					local cursorPos = scene:GetCursorPos();
					if ( CanBePlacedHere(actor) ) then
						PlaceObject(actor);
						if debug_show_placed_location then
							scene.DEBUG_OUT:SayRaw(_info.image .. ": x = " .. actor:GetPosition().x .. ", y = " .. actor:GetPosition().y);
						end
						actor:SetAlpha(1);
						actor.moving = false;
						moving_actor:LoadZone(actor.info.image);
						actor:SetPointAtCursor("cursor_open_hand");
					elseif ( PointInRectangle( { x = cursorPos.x, y = cursorPos.y }, { tlx = floorFormatInfo["screen_x_offset"], tly = floorFormatInfo["screen_y_offset"], brx = floorFormatInfo["screen_x_offset"] + floorFormatInfo["floor_width"], bry = floorFormatInfo["screen_y_offset"] + floorFormatInfo["floor_height"] } ) )  then
					-- if clicking on floor
						actor:JumpToPoint { x = actor["info"].x, y = actor["info"].y };	
						actor:SetAlpha(1);
						sfx:PlaySFX( "audio/sfx/drop_supply_floor.ogg", false );
						actor.moving = false;
						moving_actor:LoadZone(actor.info.image);
						actor:SetPointAtCursor("cursor_open_hand");
					else -- otherwise do nothing other than play the sound effect
						sfx:PlaySFX( "audio/sfx/clicksound_ground_invalid.ogg", false );
					end 
				end
				return RESPONSE.IGNORE;
			end;
		end;
	}
end

function move_item(actor)
	moving_actor = actor;
	while actor.moving do
		actor.collisionUsed = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
		if ( actor.placed ) then
			UnplaceObject(actor);
		end
		local cursorPos = scene:GetCursorPos();
		actor:JumpToPoint { x = cursorPos.x + actor.movingx, y = cursorPos.y + actor.movingy };	
		UpdateGridHighlighting(actor, info);
		if ( CanBePlacedHere(actor) ) then
			Highlight(actor);
		else
			UnhighlightGrid();
		end
		actor:SetAlpha(0.7);
		delay(1);
	end
	moving_actor = nil;
end

function UnplaceObject(actor)
	local numGridSquares = gridFormatInfo["grid_height"] * gridFormatInfo["grid_width"];
	for i = 1, numGridSquares do
		if ( grid[i].occupied == actor.name ) then
			grid[i].highlighted = grid[i].occupied;
			grid[i].occupied = "";
			grid[i]:LoadImage(gridSquare.highlight);
		end
	end
	actor.placed = false;
end

function PlaceObject(actor)
	local numGridSquares = gridFormatInfo["grid_height"] * gridFormatInfo["grid_width"];	
	for i = 1, numGridSquares do
		if ( grid[i].highlighted == actor.name ) then
			grid[i].occupied = grid[i].highlighted;
			grid[i].highlighted = "";	
			grid[i]:LoadImage(gridSquare.occupied);
		end
	end
	actor.placed = true;
	actor:JumpToPoint { x = actor["snapToPos"].x, y = actor["snapToPos"].y };
	sfx:PlaySFX( "audio/sfx/drop_supply_box.ogg", false );
	
	if ( WholeGridOccupied() ) then
		scene.FLO:StartProc(activity_passed);
	end
end

hint_button_spec = 
{
	name = "HINT_BUTTON";
	text = "hint";
	halo = "quest/objects/button_thin";
	position = { x = 588, y = 530+hud_lower_offset };
	image = "buttons/button_thin";
	clicksound = "audio/sfx/buttonclick";
	rolloversound = "audio/sfx/button_rollover";
	depth = 50;
	say_spec =
		{
			color = { a = 1, r = 0, g = 0, b = 0 },
			color_over = { a = 1, r = 0, g = 0, b = 0 },
			y = 11,
			x = 0,
			w = 110,
			h = 20,
			bubble = false,
			lineheight = 17,
			outline_size = 0,
			font = "fonts/franklingothic_demicond.mvec"; 
			anchor = ANCHOR.CENTER
		};
	
	on_click = function(flo, actor)
		MET_Count("HintsClicked");
		globalFlo = flo;
		local hintCount = 0;
		local index = 0;
		for i = 1, numPackageItems do
			if ( package_items[i].info.hint == true ) then
				hintCount = hintCount + 1;
			end
			if ( hintCount == currentHint ) then
				currentHint = currentHint + 1;
				if ( currentHint > maxHints ) then
					currentHint = 1;
				end
				index = i;
				break;
			end
		end
		-- Give Hint
		-- if item placed correctly
		local item = package_items[index];
		if ( item.placed == true and item.snapToPos.x == currentSolution[index].x and item.snapToPos.y == currentSolution[index].y ) then
			help_panel_say_raw( scene:grabstring("item_correct") );
			autoPlace = false;
			item:StartProc(FlashItem);
		else
			if item.moving == true then
				item:SetAlpha(1);
				item.moving = false;
				item:LoadZone(item.info.image);
				item:SetPointAtCursor("cursor_open_hand");
				moving_actor = nil;
			elseif ( item.placed ) then
				--item.collisionUsed = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
				UnplaceObject(item);
				UpdateGridHighlighting(item);
			end
			help_panel_say_raw( scene:grabstring("item_incorrect") );
			item:WalkToXY( currentSolution[index] );
			autoPlace = true;
			item:StartProc(FlashItem);			
		end		
	end;
}

function HideHintButton()
	if game:Get("activity_mode") ~= 1 then
		scene.HINT_BUTTON:SetAlpha( 0 );
		scene.HINT_BUTTON:SayRaw( "" );
		scene.HINT_BUTTON:DumpZone();
		scene.HINT_BUTTON:ModifySaySpec
		{
			lineheight = 0,
		};
	end
end

function ShowHintButton()
	if game:Get("activity_mode") ~= 1 then
		if scene.HINT_BUTTON then
			scene.HINT_BUTTON:SetAlpha( 1 );
			scene.HINT_BUTTON:ModifySaySpec
			{
				lineheight = 17,
			};
			scene.HINT_BUTTON:LoadZone("quest/objects/button_thin");
			scene.HINT_BUTTON:SayRaw( scene:grabstring( "hint" ) );
		end
	end
end

function FlashItem( item )
	local item_depth_value = item:GetDepthValue();
	globalFlo:SetMode( MODE.CUTSCENE );
	HideHintButton();
	item:SetDepthValue(50);
	wait_walkto(item);
	
	local scale_up = { x = item.info.img_scale.x * 1.2, y = item.info.img_scale.y * 1.2 };
	local original_pos = item:GetPosition();
	
	local image_size1 = item:GetImageSize();
	image_size1.x = image_size1.x * item.info.img_scale.x;
	image_size1.y = image_size1.y * item.info.img_scale.y;
	item:SetScaleXY(scale_up);
	local image_size2 = item:GetImageSize();
	image_size2.x = image_size2.x * scale_up.x;
	image_size2.y = image_size2.y * scale_up.y;
	
	local scale_pos = { x = 0, y = 0};
	scale_pos.x = original_pos.x - ((image_size2.x - image_size1.x) / 2);
	scale_pos.y = original_pos.y - ((image_size2.x - image_size1.x) / 2);
	
	item:SetScaleXY(item.info.img_scale);
	
	for i = 1, 3 do
		item:SetScaleXY(scale_up)
		item:JumpToPoint(scale_pos);
		delay(15);		
		item:SetScaleXY(item.info.img_scale)
		item:JumpToPoint(original_pos);
		delay(15);
	end		
	item:SetScaleXY(item.info.img_scale)
	item:JumpToPoint(original_pos);
	if ( autoPlace == true ) then
		autoPlace = false;
		UpdateGridHighlighting(item);
		if ( CanBePlacedHere( item ) ) then
			PlaceObject( item );
		else
			item:WalkToXY(item.info);
			wait_walkto(item);
			--item:JumpToPoint( item.info );	
		end
	end
	item:SetDepthValue(item_depth_value);
	
	coroutine.yield(RESUME.ON_CLICK);
	
	-- resume our regular broadcast
	local activityNum = game:Get("mg_package_activity_num");
	local activityRound = game:Get("mg_package_activity_round");

	if activityNum == 1 and activityRound == 1 then
		help_panel_say_raw(scene:grabstring("tutorial_1"));
	else
		help_panel_say_raw(scene:grabstring("help_" .. tostring(activityRound) .. "_" .. tostring(activityNum)));
	end
	
	ShowHintButton();
	globalFlo:SetMode( MODE.FOLLOWCLICKS );
end

function WholeGridOccupied()
	local numGridSquares = gridFormatInfo["grid_height"] * gridFormatInfo["grid_width"];
	for i = 1, numGridSquares do
		if ( grid[i].occupied == "" ) then
			return false;
		end		
	end
	return true;
end

function CanBePlacedHere( actor )
	local numCollisionBits = collisionInfo.maxCollisionWidth * collisionInfo.maxCollisionHeight;
	for i = 1, numCollisionBits do
		if ( ( actor["info"].collisionMask[i] == 1 ) and ( actor.collisionUsed[i] ~= 1 ) ) then
			return false;
		end
	end
	-- all collision is being used, i.e. they entire object is on an unoccupied part of the grid
	return true
end

function Highlight( actor )
	local numGridSquares = gridFormatInfo["grid_height"] * gridFormatInfo["grid_width"];	
	for i = 1, numGridSquares do
		if ( grid[i].highlighted == actor.name ) then
			grid[i]:LoadImage(gridSquare.highlight);
		end
	end
end

function UnhighlightGrid()
	local numGridSquares = gridFormatInfo["grid_height"] * gridFormatInfo["grid_width"];
	for i = 1, numGridSquares do
		if ( grid[i].occupied == "" ) then 
			grid[i].highlighted = "";
			grid[i]:LoadImage(gridSquare.image);
		end
	end
end

function UpdateGridHighlighting(actor)
	local position = actor:GetPosition();
	local xPos = position.x + actor["info"].xCollisionCheckOffset;
	local yPos = position.y + actor["info"].yCollisionCheckOffset;
	-- Find corresponding position on the grid
	local numGridSquares = gridFormatInfo["grid_height"] * gridFormatInfo["grid_width"];
	local gridSquareCentreIndexX = 0;
	local gridSquareCentreIndexY = 0;
	for i = 1, numGridSquares do
		local squarePosition = grid[i]:GetPosition();
		local squareXPos = squarePosition.x;
		local squareYPos = squarePosition.y;
		if ( PointInRectangle( { x = xPos, y = yPos }, { tlx = squareXPos, tly = squareYPos, brx = squareXPos + gridSquare.width, bry = squareYPos + gridSquare.height } ) ) then
			gridSquareCentreIndexX = grid[i].xIndex;
			gridSquareCentreIndexY = grid[i].yIndex;
			actor["snapToPos"].x = squareXPos + ( gridSquare.width / 2 ) - actor["info"].xCollisionCheckOffset;
			actor["snapToPos"].y = squareYPos + ( gridSquare.height / 2 ) - actor["info"].yCollisionCheckOffset;
			break;
		end
	end
	UnhighlightGrid();
	if ( gridSquareCentreIndexX == 0 or gridSquareCentreIndexY == 0 ) then
		return;
	end
	-- For each square in collision mask, check offset against grid	
	for i = 1, collisionInfo.maxCollisionWidth do	
		local relativeXPosition = i - ( math.floor( collisionInfo.maxCollisionWidth / 2 ) + 1 );
		for j = 1, collisionInfo.maxCollisionHeight do
			local hasCollision = HasCollisionAt( actor, i, j );
			local relativeYPosition = j - ( math.floor( collisionInfo.maxCollisionHeight / 2 ) + 1 );
			local gridSquareX = gridSquareCentreIndexX + relativeXPosition;
			local gridSquareY = gridSquareCentreIndexY + relativeYPosition;
			local pointInRectangle = PointInRectangle( { x = gridSquareX, y = gridSquareY }, { tlx = 1, tly = 1, brx = gridFormatInfo["grid_width"], bry = gridFormatInfo["grid_height"] } );
			local index = ( (gridSquareY - 1) * gridFormatInfo["grid_width"] ) + gridSquareX;				
			local collisionIndex = ( (j - 1) * collisionInfo.maxCollisionWidth ) + i;	
			actor.collisionUsed[collisionIndex] = 0;		
			if ( pointInRectangle ) then
				local squareIsUnoccupied = ( grid[index].occupied == "" );
				grid[index].highlighted = "";
				if ( hasCollision and squareIsUnoccupied ) then
					actor.collisionUsed[collisionIndex] = 1;
					grid[index].highlighted = actor.name;
				end
			end
		end
	end	
end

function HasCollisionAt( actor, x, y )
	local index = ( (y - 1) * collisionInfo.maxCollisionWidth ) + x;	
	if ( actor["info"].collisionMask[index] == 1 ) then
		return true;
	end
	return false;
end

function PointInRectangle( point, rectangle )
	if ( point.x < rectangle.tlx ) then
		return false;
	elseif ( point.x > rectangle.brx ) then
		return false;
	elseif ( point.y < rectangle.tly ) then
		return false;
	elseif ( point.y > rectangle.bry ) then
		return false;
	end
	return true;
end

function reset()
	if ( gridSpawned ) then	
		for i = 1, gridFormatInfo["grid_height"] do
			for j = 1, gridFormatInfo["grid_width"] do
				local index = ( (i - 1) * gridFormatInfo["grid_width"] ) + j;	
				grid[index]:Expire();
			end
		end
	end
	grid = { };
	gridSpawned = false;	
	
	for i = 1, numPackageItems do
		package_items[i]:Expire();
	end
	package_items = { };
	numPackageItems = 0;		
	currentHint = 1;
	maxHints = 0;
end

function spawn_package_items(actor)
	local round = game:Get("mg_package_activity_round");
	local activity_num = game:Get("mg_package_activity_num");
	local activity_mode = game:Get("activity_mode") == 1;
	
	if activity_mode then
		activity_num = game:Get("activity_mode_level");
		round = table.getn(round_num);
	end
	
	local activity_data = items[round][activity_num];
	if activity_data then
		for j,w in pairs(activity_data.items) do
			local package_item_spec = get_package_item_spec(tostring(j) .. tostring( game:Get("mg_package_activity_num") ), w);
			if currentDepth <= w.depth then
				currentDepth = w.depth + 1;
			end								
			numPackageItems = numPackageItems + 1;
			if ( w.hint == true ) then
				maxHints = maxHints + 1;
			end
			table.insert( package_items, numPackageItems, scene:Spawn(package_item_spec) );
			sfx:PlaySFX("audio/sfx/new_supplies");
			delay(SECOND_DELAY);
		end
		currentSolution = activity_data.solution;
	end
end

function spawn_grid()
	for i = 1, gridFormatInfo["grid_height"] do
		for j = 1, gridFormatInfo["grid_width"] do
			local xPos = gridFormatInfo["screen_x_offset"] + ( j - 1 ) * gridSquare.width;
			local yPos = gridFormatInfo["screen_y_offset"] + ( i - 1 ) * gridSquare.height;
			local gridSquare_item_spec = get_gridSquare_item_spec( "gridSquare" .. tostring( game:Get("mg_package_activity_num") ) .. tostring(j) .. tostring(i), gridSquare.image, xPos, yPos, j, i );
			local index = ( (i - 1) * gridFormatInfo["grid_width"] ) + j;	
			table.insert( grid, index, scene:Spawn(gridSquare_item_spec));
		end
	end
	gridSpawned = true;
end

function get_gridSquare_item_spec(_name, _image, _x, _y, _xIndex, _yIndex)
	return
	{
		name = _name;
		halo = _image;
		gfx = { image = _image };
	
		command = function(actor)
			actor:SetDepthValue(2);
			actor:JumpToPoint { x = _x, y = _y };
			actor:SetPointAtCursor("cursor");
			actor:SetAlpha(1);
			actor:ModifySaySpec
			{
				color = { a = 1, r = 0, g = 0, b = 0 },
				y = 30,
				x = -15,
				w = 90,
				h = 25,
				bubble = false,
				outline_size = 0,
				font = "fonts/garamondpremierpro.mvec"; 
				anchor = ANCHOR.CENTER
			};
			actor.moving = false;
			actor.xIndex = _xIndex;
			actor.yIndex = _yIndex;
			actor.occupied = "";
			actor.highlighted = "";
		end;
	}
end

function setup_activity()
	local activityNum = game:Get("mg_package_activity_num");
	local activityRound = game:Get("mg_package_activity_round");
	local activityMode = game:Get("activity_mode") == 1;
	
	if activityMode then
		activityNum = game:Get("activity_mode_level");
		activityRound = table.getn(round_num);
	end
	
	if initial_setup then
		if show_activity_text == true then
			scene:Spawn(activity_title_spec);
			scene:Spawn(round_num_spec);
			scene:Spawn(activity_num_spec);
		end
		initial_setup = false;
		coroutine.yield(RESUME.NOW);
	else
	end

	if not activityMode then
		if activityNum == 1 and activityRound == 1 then
			help_panel_say_raw(scene:grabstring("tutorial_1"));
		else
			help_panel_say_raw(scene:grabstring("help_" .. tostring(activityRound) .. "_" .. tostring(activityNum)));
		end
	end
	
	if show_activity_text == true then
		scene.ACTIVITY_NUM:SayRaw(scene:grabstring("activity") .. " " .. tostring(activityNum));
		scene.ROUND_NUM:SayRaw(scene:grabstring("round") .. " " .. tostring(activityRound));
	end
	
	reset();
	HideHintButton();
	coroutine.yield(RESUME.NOW);
	
	safe_spawn_actor(blocker_spec);
	spawn_box();
	DoTransitionOn();
	spawn_grid();
	spawn_package_items();
	ShowHintButton();
	scene[blocker_spec.name]:Expire();
end;

function spawn_box()
	box = scene:Spawn( box_spec );
	boxlid = scene:Spawn( box_lid_spec );
end

function DoTransitionOn()
	sfx:PlaySFX("audio/sfx/box_slide.ogg");
	local j = 0;
	local speed = 10;
	while ( j < 500 ) do
		local pos = { x = 0, y = 0 };
		box:JumpToPoint( { x = pos.x - ( 500 - j ), y = pos.y } );					
		boxlid:JumpToPoint( { x = pos.x - ( 500 - j ), y = pos.y } );							
		j = j + speed;		
		delay(1);
	end
end

function DoTransitionOff()
	sfx:PlaySFX("audio/sfx/box_wrap.ogg");
	boxlid:PlayAnim( "BoxClose1" );
	boxlid:SetDepthValue(currentDepth + 1);
	boxlid:SetScale(1.3333333333333);
	wait_anim(boxlid);
	boxlid:PlayAnim( "BoxClose2" );
	wait_anim(boxlid);
	boxlid:PlayAnim( "BoxClose3" );
	wait_anim(boxlid);
	boxlid:PlayAnim( "BoxClose4" );
	wait_anim(boxlid);
	
	for i = 1, numPackageItems do
		package_items[i]:SetAlpha(0);
	end
	local numGridSquares = gridFormatInfo["grid_height"] * gridFormatInfo["grid_width"];
	for i = 1, numGridSquares do
		grid[i]:SetAlpha(0);
	end
	local j = 0;
	local speed = 10;
	while ( j < 100 ) do
		local pos = box:GetPosition();
		box:JumpToPoint( { x = pos.x - speed, y = pos.y } );			
		pos = boxlid:GetPosition();
		boxlid:JumpToPoint( { x = pos.x - speed, y = pos.y } );							
		j = j + 1;		
		delay(1);
	end	
	box:Expire();
	box = nil;
	boxlid:Expire();
	boxlid = nil;
end

function next_activity(flo)
	local activityNum = game:Get("mg_package_activity_num");
	local activityRound = game:Get("mg_package_activity_round");
	local roundComplete = activityNum == 1; -- on next round
	local activityMode = game:Get("activity_mode") == 1;
	
	if not activityMode then
		scene.NEXT_ACTIVITY_BUTTON:Expire();
	end
	
	DoTransitionOff();
	passed = false;
	
	if not activityMode and roundComplete then	
		goto_scene(flo, "m1_petshop");	
	else
		if IsCheatMode() then
			if not activityMode then
				spawn_button(pass_activity_button_spec);
			end
		end
		
		if activityMode then
			spawn_button(start_button_spec);
			move_actor_y(scene.START_BUTTON, -hud_lower_offset);
		else
			spawn_button(hint_button_spec);
			move_actor_y(scene.HINT_BUTTON, -hud_lower_offset);
		end
		
		spawn_button(back_button_spec);
		move_actor_y(scene.BACK_BUTTON, -hud_lower_offset);
		
		if not activityMode then
			-- load new puzzle		
			setup_activity();
		else
			kill_activity_timer();
		end
	end
end;

function activity_passed(flo)
	passed = true;
	stop_activity_timer(); -- quest/activity_mode/activity_timer.lua
	local activityNum = game:Get("mg_package_activity_num");
	local activityRound = game:Get("mg_package_activity_round");
	local roundComplete = activityNum == round_num[activityRound];
	local activityMode = game:Get("activity_mode") == 1;
	
	if IsCheatMode() then
		scene.PASS_ACTIVITY_BUTTON:Expire();
	end
	
	if not activityMode then
		scene.HINT_BUTTON:Expire();
	end
	
	scene.BACK_BUTTON:Expire();
	
	if not activityMode then
		spawn_button(next_activity_button_spec);
		scene.NEXT_ACTIVITY_BUTTON:StartProc(pulse_actor);
		
		help_panel_say_raw(
			scene:grabstring("finished_" .. tostring(activityRound) .. "_" .. tostring(activityNum)));
		
		if roundComplete then
			if activityRound == 1 then -- only one round
				game:Set("mg_package_activity_round", 2);
				game:Set("mg_package_activity_num", 1);
			end
		else
			game:Set("mg_package_activity_num", activityNum + 1);
		end
	end
	
	-- save progress
	-- we're not saving our progress if the round is complete, as this will take us to an invalid screen
	if activityMode or not roundComplete then
		game:SaveGame();
	end
	
	scene:Spawn(blocker_spec);
	
	spawn_activity_complete_text("activity_complete_text", "audio/sfx/complete_box.ogg");
	coroutine.yield(RESUME.ON_SIGNAL);
	
	if activityMode then
		activityNum = game:Get("activity_mode_level");
		activityRound = table.getn(round_num);
		roundComplete = activityNum == round_num[activityRound];
		
		--if roundComplete then
		--	game:EarnAward("avenue-flo_packaging");
		--end
	
		show_activity_results();
	end
end;

function fail_activity(flo)
	-- display message of some sort
	setup_activity();
end;

flo_spec =
{
	name = "FLO";
	
	command = function(actor)
		prepare_actor_text(actor, flo_text_spec);
		actor:SetMode(MODE.FOLLOWCLICKS);
	end;
};

activity_title_spec = 
{
	name = "ACTIVITY_TITLE";
	
	command = function(actor)
		actor:JumpToPoint { x = 300, y = 10 };
		actor:ModifySaySpec
		{
			color = { a = 1, r = 0, g = 0, b = 0 },
			y = 19,
			x = 5,
			w = 250,
			h = 50,
			lineheight = 40,
			bubble = false,
			outline_size = 0,
			font = "fonts/garamondpremierpro.mvec"; 
			anchor = ANCHOR.CENTER
		};
		actor:SayRaw(scene:grabstring("activity_title"));
	end;
};

round_num_spec = 
{
	name = "ROUND_NUM";
	
	command = function(actor)
		actor:JumpToPoint { x = 300, y = 60 };
		actor:ModifySaySpec
		{
			color = { a = 1, r = 0, g = 0, b = 0 },
			y = 19,
			x = 5,
			w = 250,
			h = 50,
			lineheight = 30,
			bubble = false,
			outline_size = 0,
			font = "fonts/garamondpremierpro.mvec"; 
			anchor = ANCHOR.CENTER
		};
	end;
};

activity_num_spec = 
{
	name = "ACTIVITY_NUM";
	
	command = function(actor)
		actor:JumpToPoint { x = 300, y = 120 };
		actor:ModifySaySpec
		{
			color = { a = 1, r = 0, g = 0, b = 0 },
			y = 19,
			x = 5,
			w = 250,
			h = 50,
			lineheight = 30,
			bubble = false,
			outline_size = 0,
			font = "fonts/garamondpremierpro.mvec"; 
			anchor = ANCHOR.CENTER
		};
	end;
};

function pass_activity(flo)
	flo:StartProc(activity_passed);
end

function go_back(flo)
	kill_help_panel();
	goto_scene(flo, "m1_petshop");
end

box_spec = 
{
	name = "BOX";
	gfx = { image = "box" };
	
	command = function(actor)
		actor:SetDepthValue(1);
	end;
}

box_lid_anim_table = 
{
	"anim/mg_package/box_lid1",
	"anim/mg_package/box_lid1a",
	"anim/mg_package/box_lid1b",
	"anim/mg_package/box_lid1c",
	"anim/mg_package/box_lid2"
}

box_lid_spec = 
{
	name = "BOX_LID";
	anim = box_lid_anim_table;
	
	command = function(actor)
		actor:SetDepthValue(4);
		actor:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
		actor:PlayAnim( "BoxOpen" );	
	end;
}

blocker_spec = 
{
	name = "BLOCKER";
	halo = "background";
	
	command = function(actor)
		actor:SetDepthValue(600);
		actor:SetPointAtCursor("cursor");
	end;
	
	on_arrive = function(flo, actor)
		sfx:PlaySFX("audio/sfx/clicksound_ground_invalid");
	end;
}

scene_setup =
{
	name = "SETUP",
	command = function(actor)
		sfx:SetMusic("audio/music/music_activity2.ogg", true);
		scene:SetRoomScale(300, 550, 0.7, 1.1);	--topline, bottomline, topscale, bottomscale
		delay(1); -- so any variables can be set properly (i.e. activity_mode)
		local activityMode = game:Get("activity_mode") == 1;
		game:ClearInvUsage();
		
		fade_scene_up(true);
		lower_hud();
		
		if activityMode then
			spawn_button(start_button_spec);
		else
			spawn_button(hint_button_spec);
		end
		
		spawn_help_panel();
		
		if IsCheatMode() then
			--testing
			if game:GetString("package_level") == "" then
				game:SetString("package_level", "level_one");
			end
			
			if not activityMode then
				spawn_button(pass_activity_button_spec);
			end
		end
		
		-- set up for initial play
		if game:Get("mg_package_activity_num") < 1 then
			game:Set("mg_package_activity_num", 1);
		end
		
		if game:Get("mg_package_activity_round") < 1 then
			game:Set("mg_package_activity_round", 1);
		end
		
		-- unlock packaging in activity mode
		if game:Get("package_unlocked") < 1 then
			game:Set("package_unlocked", 1);
			game:Set("activity_unlocked", 1);
		end
		
		if not activityMode then
			setup_activity();
		else
			help_panel_activity_mode_intro();
		end
	end;
};

scene_spec =
{
	atlas = 
	{
		"pieces",
	};
	
	bg_image = 
	{
		{ "background", DEPTH.DEPTH_BACKMOST  },
		
		--{ "objects", 5 },

		--{ "foreground", DEPTH.DEPTH_FRONTMOST },
	};
	
	--lightmap = "lightmap";	-- use the ground as the lightmap
	
	ground = "background";
	
	actorlist = 
	{ 
		flo_spec, -- the main actor
		scene_setup,
	};
};
